<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class StaticPage extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'static_pages';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'slug',
        'sub_title',
        'description',
    ];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    /**
     * Automatically generate slug on creating or updating
     */
    protected static function booted()
    {
        static::creating(function ($page) {
            $page->slug = static::generateSlug($page->title);
        });

        static::updating(function ($page) {
            // Only regenerate slug if title has changed
            if ($page->isDirty('title')) {
                $page->slug = static::generateSlug($page->title);
            }
        });
    }

    /**
     * Generate a unique slug
     */
    public static function generateSlug($title)
    {
        $slug = Str::slug($title);
        $originalSlug = $slug;
        $count = 1;

        // Ensure uniqueness
        while (static::where('slug', $slug)->exists()) {
            $slug = $originalSlug . '-' . $count++;
        }

        return $slug;
    }
}
