<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlanFeature extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'plan_id',
        'name'
    ];
    
    protected $casts = [
        'plan_id' => 'integer',
    ];

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }
}
