<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'price',
        'billing_cycle'
    ];

    public function planFeature()
    {
        return $this->hasMany(PlanFeature::class, 'plan_id')->select('plan_id','name','id');
    }
}
