<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Feedback extends Model
{
    protected $table = 'feedbacks';
    
    protected $fillable = [
        'user_id',
        'feedback_for_type',
        'feedback_for_id',
        'type',
        'message',
    ];

     public function user()
    {
        return $this->belongsTo(AppUser::class, 'user_id');
    }

    public function content()
    {
        return $this->belongsTo(Content::class, 'feedback_for_id');
    }
}

