<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chapter extends Model
{
    use SoftDeletes;

    protected $fillable = ['course_id', 'chapter_type','title','order_index','is_free','chapter_content'];

    protected $hidden = ['created_at', 'updated_at','order_index','is_free'];

    //protected $appends = ['chapter_type_label'];

    public function course()
    {
        return $this->belongsTo(Course::class);
    }
    
    protected $casts = [
        'course_id' => 'integer',  // 👈 Force integer
    ];

    public function getChapterTypeLabelAttribute()
    {
        return getChapterTypeLabel($this->chapter_type); // Reuses the helper function
    }
}
