<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class AppUser extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'app_users';

    protected $fillable = [
        'name', 'mobile_no', 'email', 'college_id', 'referral_code', 'referred_by_user_id',
        'profile_photo_url', 'otp', 'otp_expires_at', 'is_active','is_register'
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'otp_expires_at' => 'datetime',
        'is_active' => 'boolean',
    ];

    public function college()
    {
        return $this->belongsTo(College::class, 'college_id');
    }

    public function referredBy()
    {
        return $this->belongsTo(AppUser::class, 'referred_by_user_id');
    }

    public function referredUsers()
    {
        return $this->hasMany(AppUser::class, 'referred_by_user_id');
    }
}