<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Notification;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Validator;

class NotificationController extends Controller
{

    public function index()
    {
      $notify = Notification::with(['courses:id,name'])
        ->select('id', 'course_id', 'title', 'created_at')
        ->orderBy('created_at', 'desc')
        ->get()
        ->map(function ($notification) {
            $createdAt = $notification->created_at->timezone('Asia/Kolkata'); // Convert to IST

            $formattedDate = $createdAt->isToday()
            ? $createdAt->diffForHumans() // "2 hours ago"
            : $createdAt->format('F d, Y'); // "June 02, 2025"
            
            return [
                'id' => $notification->id,
                'title' => $notification->title,
                'course_name' => $notification->courses->name ?? 'No Course',
                'created_at' => $formattedDate
            ];
        });

        return response()->json([
            'status' => 'valid',
            'message' => 'Notification fetched successfully',
            'data' => $notify
        ]);
    }


   
    
}
