<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AppSplashScreen;
use App\Models\Banner;
use App\Models\StaticPage;
use Illuminate\Support\Facades\Validator;
use App\Models\Setting;

class AppSplashScreensController extends Controller
{
    public function app_splash_screens()
    {
        $app_splash_screens = AppSplashScreen::orderBy('priority', 'ASC')
            ->select(
                'id',
                'image',
                'title',
                'description',
                'priority'
            )
            ->get();

        foreach ($app_splash_screens as $value) {
            if ($value->image != '') {
                $value->image = getPresignedUrl($value->image);
            }
        }
        $responseData = array('status' => 'valid', 'message' => 'App Splash Screens Getting Successful', 'data' => $app_splash_screens);
        return \Response::json($responseData);
    }
    
    public function banners()
    {
        $app_splash_screens = Banner::orderBy('priority', 'ASC')
            ->select(
                'id',
                'image',
                'title',
                'priority'
            )
            ->get();

        foreach ($app_splash_screens as $value) {
            if ($value->image != '') {
                $value->image = getPresignedUrl('banners/'.$value->image);
            }
        }

        $responseData = array('status' => 'valid', 'message' => 'Banners Getting Successful', 'data' => $app_splash_screens);
        return \Response::json($responseData);
    }

    public function staticPage(Request $request)
    {
        try {
            // Validate required fields
            $validator = Validator::make($request->all(), [
                'slug'    => 'required',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status'  => 'invalid',
                    'message' => 'Validation failed',
                    'errors'  => $validator->errors()
                ], 422);
            }

            if($request->slug == 'contact-us'){
                // Fetch chapters
                $pageData = Setting::findOrFail(1);

                $phones = [];
                if (!empty($pageData->phone)) {
                    $phones[] = $pageData->phone;
                }
                if (!empty($pageData->alternative_number)) {
                    $phones[] = $pageData->alternative_number;
                }
                
                $page['address']  = $pageData->address;
                $page['phone']  = $phones;
                $page['coordinates'] = [
                    'latitude'  => $pageData->latitude ?? null,
                    'longitude' => $pageData->longitude ?? null,
                ];
                $page['email']  = $pageData->email;

            }else{
                // Fetch chapters
                $page = StaticPage::select('id', 'title', 'sub_title','description')
                    ->where('slug', $request->slug)
                    ->first();

            }

            

            return response()->json([
                'status'  => 'valid',
                'message' => 'Page fetched successfully',
                'data'    => $page
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'status'  => 'error',
                'message' => 'Something went wrong.',
                'error'   => $e->getMessage()
            ], 500);
        }
    }

}
