<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Http\Request;
use App\Models\AppSplashScreen;
use Illuminate\Support\Facades\Auth;

class AdminAppSplashScreensController extends Controller
{
    public function index()
    {
        $screens = AppSplashScreen::orderBy('priority', 'asc')->get();
        return view('admin.app_splash_screens.index', compact('screens'));
    }

    public function create()
    {
        return view('admin.app_splash_screens.create');
    }

    public function store(Request $request)
    {
        $data = $this->validate($request, [
            'priority' => 'required|numeric|unique:app_splash_screens',
            'title' => 'required|string',
            'description' => 'required|string',
            'image' => 'required|mimes:png,jpeg,jpg,webp|max:10248'
        ]);
        if ($request->hasFile('image')) {
            $image2 = $request->file('image');
            $image_name2 = md5(rand(1000000, 99999999999) . time()) . '.' . $image2->getClientOriginalExtension();
            $path1 = public_path('/uploads');
            $image2->move($path1, $image_name2);

            $data['image'] = $image_name2;
        }


        $banners = (new AppSplashScreen)->storeData($data);
        return redirect()->route('admin.app_splash_screens.index')->with('message', 'App Splash Screen Created Successfully');
    }

    public function edit($id)
    {
        $screens = (new AppSplashScreen)->getDataById($id);

        return view('admin.app_splash_screens.edit', compact('screens'));
    }

    public function update(Request $request, $id)
    {

        $banner = (new AppSplashScreen)->getDataById($id);
        $data = $this->validate($request, [
            'priority' => 'required|numeric',
            'title' => 'required|string',
            'description' => 'required|string'
        ]);

        $image_name1 = $banner->image;

        if ($request->hasFile('image')) {
            $image1 = $request->file('image');
            $image_name1 = md5(rand(1000000, 99999999999) . time()) . '.' . $image1->getClientOriginalExtension();
            $path = public_path('/uploads');
            $image1->move($path, $image_name1);
            $filename = "uploads/" . $image1;

            $data['image'] = $image_name1;
        }


        $update = (new AppSplashScreen)->updateData($data, $id);

        return redirect()->route('admin.app_splash_screens.index')->with('message', 'Screen Update');
    }

    public function destroy($id)
    {
        (new AppSplashScreen)->deleteData($id);
        return redirect()->route('admin.app_splash_screens.index')->with('message', 'Screen Deleted');
    }
}
