<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\StaticPage;

class StaticPageController extends Controller
{
    public function index()
    {
        $pages = StaticPage::orderBy('created_at', 'asc')->get();
        return view('admin.static_pages.index', compact('pages'));
    }

    public function create()
    {
        return view('admin.static_pages.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'required|string|max:255',
            //'slug' => 'required|string|max:255|unique:static_pages,slug',
            'sub_title' => 'nullable|string|max:255',
            'description' => 'nullable|string',
        ]);

        StaticPage::create($data);

        return redirect()->route('admin.static_pages.index')
            ->with('success', 'Static page created successfully.');
    }

    public function edit(StaticPage $staticPage)
    {
        return view('admin.static_pages.edit', compact('staticPage'));
    }

    public function update(Request $request, StaticPage $staticPage)
    {
        $data = $request->validate([
            'title' => 'required|string|max:255',
           // 'slug' => 'required|string|max:255|unique:static_pages,slug,' . $staticPage->id,
            'sub_title' => 'nullable|string|max:255',
            'description' => 'nullable|string',
        ]);

        $staticPage->update($data);

        return redirect()->route('admin.static_pages.index')
            ->with('success', 'Static page updated successfully.');
    }

    public function destroy(StaticPage $staticPage)
    {
        $staticPage->delete();

        return redirect()->route('admin.static_pages.index')
            ->with('success', 'Static page deleted successfully.');
    }
}
