<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;

class ProfileController extends Controller
{
    public function index()
    {
        return view('admin.profile.profile');
    }
    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        //
    }
    public function show($id)
    {
        //
    }
    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        $user = User::findOrFail($id);

        $data = $this->validate($request, [
            'email' => [
                'required',
                'email',
                'unique:users,email,' . $user->id,
                'regex:/^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,4}$/',
            ],
            'name' => ['required', 'regex:/^[A-Za-z\s\-]+$/'],
            'new_password' => 'min:6|required_with:confirm_password|same:confirm_password',
            'confirm_password' => 'required|string'
        ]);

        $user->name = $request['name'];
        $user->email = $request['email'];
        $user->password = Hash::make($request->new_password);

        if ($user->save()) {
            return redirect()->route('admin.profile.index')->with('message', 'Profile Updated');
        } else {
            return redirect()->route('admin.profile.index')->with('message', 'Profile Not Updated');
        }
    }

    public function destroy($id)
    {
        //
    }
}
