<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Plan;
use App\Models\PlanFeature;

class PlanFeatureController extends Controller
{
    // List all features for a specific plan
    public function index($plan_id)
    {
        $PlanFeature = PlanFeature::where('plan_id', $plan_id)->get();

        return view('admin.plan_features.index', compact('PlanFeature','plan_id'));
    }

    // Show form to create a new feature for a specific plan
    public function create($plan_id)
    {
        $plan = Plan::findOrFail($plan_id);
        return view('admin.plan_features.create', compact('plan'));
    }

    // Store the new feature
    public function store(Request $request, $plan_id)
    {
        $plan = Plan::findOrFail($plan_id);

        $data = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $data['plan_id'] = $plan->id;

        PlanFeature::create($data);

        return redirect()->route('admin.plan_features.index', [$plan->id])
                         ->with('success', 'Plan Feature created successfully.');
    }

    // Show form to edit a feature
    public function edit(PlanFeature $plan_feature)
    {
        return view('admin.plan_features.edit', compact('plan_feature'));
    }

    // Update a feature
    public function update(Request $request, PlanFeature $plan_feature)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        $plan_feature->update($data);

        return redirect()->route('admin.plan_features.index', ['plan_id' => $plan_feature->plan_id])
                         ->with('success', 'Plan Feature updated successfully.');
    }

    // Delete a feature
    public function destroy(PlanFeature $plan_feature)
    {
        $plan_feature->delete();

        return redirect()->back()->with('success', 'Plan feature deleted successfully.');
    }
}
