<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Plan;

class PlanController extends Controller
{
    public function index()
    {
        $plans = Plan::orderBy('created_at', 'asc')->get();
        return view('admin.plans.index', compact('plans'));
    }

    public function create()
    {
        return view('admin.plans.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            //'name' => 'required|string|max:255',
            //'name' => 'required|regex:/^[A-Za-z\s]+$/|max:255',
            'name' => 'required|regex:/^[A-Za-z\s&()\-.,]+$/|max:255',
            'price' => 'required|string',
            'billing_cycle' => 'required|string|in:month,year',
        ]);

        Plan::create($data);
        return redirect()->route('admin.plans.index')->with('success', 'Plan created successfully.');
    }

    public function edit(Plan $plan)
    {
        return view('admin.plans.edit', compact('plan'));
    }

    public function update(Request $request, Plan $plan)
    {
        $data = $request->validate([
            //'name' => 'required|string|max:255',
            //'name' => 'required|regex:/^[A-Za-z\s]+$/|max:255',
            'name' => 'required|regex:/^[A-Za-z\s&()\-.,]+$/|max:255',
            'price' => 'required|string',
            'billing_cycle' => 'required|string|in:month,year',
        ]);

        $plan->update($data);
        return redirect()->route('admin.plans.index')->with('success', 'Plan updated successfully.');
    }

    public function destroy(Plan $plan)
    {
        $plan->delete();
        return redirect()->route('admin.plans.index')->with('success', 'Plan deleted successfully.');
    }
}
