<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Feedback;

class FeedbackController extends Controller
{
    // public function index()
    // {
    //     $feedback = Feedback::with([
    //         'user',
    //         'content.subChapter.chapter.course'
    //     ])->orderBy('created_at', 'desc')->get();

    //     return view('admin.feedbacks.index', compact('feedback'));
    // }
    
    public function index()
    {
        $feedback = Feedback::with([
                'user',
                'content.subChapter.chapter.course'
            ])
            ->whereHas('user')   // only feedback with user
            ->whereHas('content.subChapter.chapter.course') // only feedback with linked course
            ->orderBy('created_at', 'desc')
            ->get();
    
        return view('admin.feedbacks.index', compact('feedback'));
    }

    public function destroy($id)
    {
        $feedback = Feedback::findOrFail($id);
        $feedback->delete(); // ✅ soft delete

        return redirect()->route('admin.feedbacks.index')
                         ->with('message', 'Feedback deleted successfully.');
    }

}
