<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Course;
use Illuminate\Validation\Rule;

class CourseController extends Controller
{
    public function index()
    {
        $course = Course::orderBy('priority', 'asc')->get();
        return view('admin.courses.index', compact('course'));
    }

    public function create()
    {
        return view('admin.courses.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            //'priority' => 'required|numeric|unique:courses',
            'priority' => [
                'required',
                'numeric',
                Rule::unique('courses')->whereNull('deleted_at'),
            ],
            //'name' => 'nullable|string|max:255',
            //'name' => 'required|regex:/^[A-Za-z\s]+$/|max:255',
            'name' => 'required|regex:/^[A-Za-z\s&()\-.,]+$/|max:255',
            'image' => 'nullable|string',
            'is_active' => 'required|boolean',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
        ]);

        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $filename = uniqid('course_') . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('uploads/courses'), $filename);
            $data['image'] = $filename;
        }

        Course::create($data);
        return redirect()->route('admin.courses.index')->with('success', 'Course created successfully.');
    }

    public function edit(Course $course)
    {
        return view('admin.courses.edit', compact('course'));
    }

    public function update(Request $request, Course $course)
    {
        // $data = $request->validate([
        //     'priority' => 'required|numeric',
        //     'name' => 'nullable|string|max:255',
        //     'is_active' => 'required|boolean',
        //     'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
        // ]);
        
        $data = $request->validate([
            'priority' => [
                'required',
                'numeric',
                Rule::unique('courses')->ignore($course->id)->whereNull('deleted_at'),
            ],
            //'name' => 'nullable|string|max:255',
            //'name' => 'required|regex:/^[A-Za-z\s]+$/|max:255',
            'name' => 'required|regex:/^[A-Za-z\s&()\-.,]+$/|max:255',
            'is_active' => 'required|boolean',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
        ]);

        if ($request->hasFile('image')) {
            // Optional: Delete old image if it exists
            if ($course->image && file_exists(public_path('uploads/courses/' . $course->image))) {
                unlink(public_path('uploads/courses/' . $course->image));
            }

            $file = $request->file('image');
            $filename = uniqid('course_') . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('uploads/courses'), $filename);
            $data['image'] = $filename;
        }

        $course->update($data);
        return redirect()->route('admin.courses.index')->with('success', 'Course updated successfully.');
    }

    public function destroy(Course $course)
    {
        if ($course->image && file_exists(public_path('uploads/courses/' . $course->image))) {
            unlink(public_path('uploads/courses/' . $course->image));
        }
        $course->delete();
        return redirect()->route('admin.courses.index')->with('success', 'Course deleted successfully.');
    }
}
