<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\College;

class CollegeController extends Controller
{
    public function index()
    {
        $college = College::orderBy('created_at', 'asc')->get();
        return view('admin.colleges.index', compact('college'));
    }

    public function create()
    {
        return view('admin.colleges.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            //'name' => 'nullable|string|max:255',
            //'name' => 'required|regex:/^[A-Za-z\s]+$/|max:255',
            'name' => 'required|regex:/^[A-Za-z\s&()\-.,]+$/|max:255',
        ]);

        College::create($data);
        return redirect()->route('admin.colleges.index')->with('success', 'College created successfully.');
    }

    public function edit(College $college)
    {
        return view('admin.colleges.edit', compact('college'));
    }

    public function update(Request $request, College $college)
    {
        $data = $request->validate([
            //'name' => 'nullable|string|max:255',
            //'name' => 'required|regex:/^[A-Za-z\s]+$/|max:255',
            'name' => 'required|regex:/^[A-Za-z\s&()\-.,]+$/|max:255',
        ]);

        $college->update($data);
        return redirect()->route('admin.colleges.index')->with('success', 'College updated successfully.');
    }

    public function destroy(College $college)
    {
        $college->delete();
        return redirect()->route('admin.colleges.index')->with('success', 'College deleted successfully.');
    }
}
