<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CollegeContent;
use App\Models\College;

class CollegeContentController extends Controller
{

    public function index($college_id)
    {
        $CollegeContent = CollegeContent::where('college_id', $college_id)
            ->get();

        return view('admin.college_contents.index', compact('CollegeContent', 'college_id'));
    }


    public function create($id)
    {
        $college = College::findOrFail($id);
        return view('admin.college_contents.create', compact('college'));
    }

    public function store(Request $request, $id)
    {
        $college = College::findOrFail($id);
        $data = $request->validate([
            'title' => 'required|string|max:255',
            'file' => 'required|mimes:pdf|max:5120', // max 5MB
        ]);

        if ($request->hasFile('file')) {
            $pdf = $request->file('file');
            $filename = uniqid('college_') . '.' . $pdf->getClientOriginalExtension();
            $pdf->move(public_path('uploads/college'), $filename);
            $data['pdf_url'] = $filename;
        }

        CollegeContent::create([
            'college_id' => $college->id,
            'title' => $data['title'],
            'pdf_url' => $data['pdf_url'],
            'order_index' => 1, // Adjust as needed
        ]);

        return redirect()->route('admin.college_contents.index', [$college->id])
                     ->with('success', 'College Content created successfully.');
    }

    public function edit(CollegeContent $content)
    {
        return view('admin.college_contents.edit', compact('content'));
    }

    public function update(Request $request, CollegeContent $content)
    {
        $data = $request->validate([
            'title' => 'required|string|max:255',
            'file' => 'nullable|mimes:pdf|max:5120',
        ]);

        if ($request->hasFile('file')) {
            if ($content->pdf_url && file_exists(public_path('uploads/college/' . $content->pdf_url))) {
                unlink(public_path('uploads/college/' . $content->pdf_url));
            }

            $pdf = $request->file('file');
            $filename = uniqid('college_') . '.' . $pdf->getClientOriginalExtension();
            $pdf->move(public_path('uploads/college'), $filename);
            $data['pdf_url'] = $filename;
        }

        $content->update($data);

        return redirect()->back()->with('success', 'College Content updated successfully.');
    }

    public function destroy(CollegeContent $content)
    {
        
        $path = public_path('uploads/college/' . $content->pdf_url);
        if (file_exists($path)) {
            unlink($path);
        }
        $content->delete();

        return redirect()->back()->with('success', 'College Content deleted successfully.');
    }


}
