<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Chapter;
use App\Models\Course;

class ChapterController extends Controller
{
    public function index()
    {
        //$chapter = Chapter::with('course')->orderBy('created_at', 'asc')->get();
        $chapter = Chapter::with(['course' => function ($query) {
            $query->whereNull('deleted_at');
        }])->whereHas('course', function ($query) {
            $query->whereNull('deleted_at');
        })->orderBy('created_at', 'asc')->get();
        return view('admin.chapters.index', compact('chapter'));
    }

    public function create()
    {
        $courses = Course::where('is_active', true)->where('name', 'not like', '%Past Question Papers%')->orderBy('priority', 'asc')->get();
        return view('admin.chapters.create', compact('courses'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            //'title' => 'nullable|string|max:255',
            'title' => 'nullable|string|max:255|unique:chapters,title',
            'course_id' => 'required|exists:courses,id',
            //'chapter_type' => 'required',
            'chapter_type' => 'nullable|string',
            'forced_chapter_type' => 'nullable|string',
            'order_index' => 'required|integer',
            //'is_free' => 'required',
        ]);
        
        // Use forced_chapter_type if provided
         if (!empty($data['forced_chapter_type'])) {
            $data['chapter_type'] = $data['forced_chapter_type'];
        }
        unset($data['forced_chapter_type']);

        Chapter::create($data);
        return redirect()->route('admin.chapters.index')->with('success', 'Chapter created successfully.');
    }

    public function edit(Chapter $chapter)
    {
        $courses = Course::where('is_active', true)->where('name', 'not like', '%Past Question Papers%')->orderBy('priority', 'asc')->get();
        return view('admin.chapters.edit', compact('chapter','courses'));
    }

    // public function update(Request $request, Chapter $chapter)
    // {
    //     $data = $request->validate([
    //         //'title' => 'nullable|string|max:255',
    //         'title' => 'nullable|string|max:255|unique:chapters,title,' . $chapter->id,
    //         'course_id' => 'required|exists:courses,id',
    //         'chapter_type' => 'required',
    //         'order_index' => 'required|integer',
    //     ]);

    //     $chapter->update($data);
    //     return redirect()->route('admin.chapters.index')->with('success', 'Chapter updated successfully.');
    // }
    
    public function update(Request $request, Chapter $chapter)
    {
        $data = $request->validate([
            'title' => 'nullable|string|max:255|unique:chapters,title,' . $chapter->id,
            'course_id' => 'required|exists:courses,id',
            'chapter_type' => 'nullable|string',
            'forced_chapter_type' => 'nullable|string',
            'order_index' => 'required|integer',
        ]);
    
        // Override if forced type is set
        if (!empty($data['forced_chapter_type'])) {
            $data['chapter_type'] = $data['forced_chapter_type'];
        }
        unset($data['forced_chapter_type']);
    
        $chapter->update($data);
    
        return redirect()->route('admin.chapters.index')->with('success', 'Chapter updated successfully.');
    }


    public function destroy(Chapter $chapter)
    {
        $chapter->delete();
        return redirect()->route('admin.chapters.index')->with('success', 'Chapter deleted successfully.');
    }
}
