<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AppUser;
class AppUserController extends Controller
{

    public function index()
    {

        $appUser = (new AppUser)->orderBy('id', 'desc')->get();
        return view('admin.app_users.index', compact('appUser'));
    }
    
      public function toggleStatus($id)
    {
        $user = AppUser::findOrFail($id);

        $user->is_active = !$user->is_active; // Toggle status
        $user->save();

        return redirect()->route('admin.appUsers.index')->with('message', 'User status updated successfully!');
    }


}
