<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SeoSetting;
use App\Models\Setting;
use Illuminate\Http\Request;
use DB;

class AdminSettingsController extends Controller
{
    public function general_settings()
    {
        // $permission_check = has_permission(40, "list");
        // // $permission_check = 1;
        // if ($permission_check == 0) {
        //     abort(403);
        // }
        $settings = Setting::findOrFail(1);
        return view('admin.settings.general', compact('settings'));
    }

    public function seo_settings()
    {
        // $permission_check = has_permission(41, "list");
        // if ($permission_check == 0) {
        //     abort(403);
        // }

        $seoSettings = SeoSetting::all();
        return view('admin.settings.seo', compact('seoSettings'));
    }

    public function seo_create()
    {
        // $permission_check = has_permission(41, "create");
        // if ($permission_check == 0) {
        //     abort(403);
        // }

        return view('admin.settings.seo_create');
    }

    public function seo_store(Request $request)
    {
        // $permission_check = has_permission(41, "create");
        // if ($permission_check == 0) {
        //     abort(403);
        // }

        $request->validate([
            'page' => 'required|unique:seo_settings,page',
            'meta_title' => 'required',
            'meta_description' => 'required',
            'meta_keywords' => 'required',
        ]);

        SeoSetting::create($request->all());

        return redirect()->route('admin.seo_settings')->with('message', 'New SEO settings added successfully.');
    }

    public function seo_edit($id)
    {
        // $permission_check = has_permission(41, "edit");
        // if ($permission_check == 0) {
        //     abort(403);
        // }

        $seo = SeoSetting::findOrFail($id);
        return view('admin.settings.seo_edit', compact('seo'));
    }

    public function seo_update(Request $request, $id)
    {
        // $permission_check = has_permission(41, "edit");
        // if ($permission_check == 0) {
        //     abort(403);
        // }

        $seo = SeoSetting::findOrFail($id);
        $seo->update($request->only(['meta_title', 'meta_description', 'meta_keywords']));

        return redirect()->route('admin.seo_settings')->with('message', 'SEO Settings Updated Successfully');
    }

    public function sm_settings()
    {
        // $permission_check = has_permission(42, "list");
        // // $permission_check = 1;
        // if ($permission_check == 0) {
        //     abort(403);
        // }
        $settings = Setting::findOrFail(1);
        return view('admin.settings.sm', compact('settings'));
    }
    public function general_update(Request $request, $id)
    {
        // $permission_check = has_permission(40, "edit");
        // // $permission_check = 1;
        // if ($permission_check == 0) {
        //     abort(403);
        // }

        $settings = Setting::findOrFail($id);
        $data = $this->validate($request, [
            'site_name' => 'required|string',
            'phone' => 'required',
            'email' => 'required|email',
            'mobile_number' => 'required'
        ]);

        $settings->site_name = $request['site_name'];
        $settings->address = $request['address'];
        $settings->latitude =  $request['latitude'];
        $settings->longitude =  $request['longitude'];
        $settings->phone = $request['phone'];
        $settings->alternative_number = $request['mobile_number'];
        $settings->email = $request['email'];
        $settings->alternative_email = $request['alternative_email'];
        $settings->address = $request['address'];
        $settings->working_days = $request['working_days'];
        $settings->android_app_link = $request['android_app_link'];
        $settings->ios_app_link = $request['ios_app_link'];
        $settings->youtube_video_instructions = $request['youtube_video_instructions'];

        // if ($request->hasFile('logo')) {
        //     $logo = $request->file('logo');
        //     $image_name = rand(100000, 9999999) . time() . '.' . $logo->getClientOriginalExtension();
        //     $path = public_path('/uploads');
        //     $logo->move($path, $image_name);
        //     $settings->logo = $image_name;
        // }
        // if ($request->hasFile('favicon')) {
        //     $favicon = $request->file('favicon');
        //     $image_name = rand(100000, 9999999) . time() . '.' . $favicon->getClientOriginalExtension();
        //     $path = public_path('/uploads');
        //     $favicon->move($path, $image_name);
        //     $settings->favicon = $image_name;
        // }

        if ($request->hasFile('logo')) {
            if ($settings->logo) {
                deleteImage($settings->logo, 'uploads'); // Pass the current profile picture and the folder where images are stored
            }
            // Upload the image using the helper function
            $logo_image = uploadImage($request->file('logo'), 'uploads');
            $settings->logo = $logo_image;
        }

        if ($request->hasFile('favicon')) {
            if ($settings->favicon) {
                deleteImage($settings->favicon, 'uploads'); // Pass the current profile picture and the folder where images are stored
            }
            // Upload the image using the helper function
            $favicon_image = uploadImage($request->file('favicon'), 'uploads');
            $settings->favicon = $favicon_image;
        }

        if ($settings->save()) {
            return redirect()->route('admin.general_settings')->with('message', 'General Settings Updated Successfully');
        } else {
            return redirect()->route('admin.general_settings')->with('message', 'General Settings Updated Successfully');
        }
    }

    public function sm_update(Request $request, $id)
    {
        // $permission_check = has_permission(42, "edit");
        // // $permission_check = 1;
        // if ($permission_check == 0) {
        //     abort(403);
        // }

        $settings = Setting::findOrFail($id);

        $settings->facebook = $request['facebook'];
        $settings->linkedin = $request['linkedin'];
        $settings->twitter = $request['twitter'];
        $settings->youtube = $request['youtube'];
        $settings->instagram = $request['instagram'];

        if ($settings->save()) {
            return redirect()->route('admin.sm_settings')->with('message', 'Social Media Settings Updated Successfully');
        } else {
            return redirect()->route('admin.sm_settings')->with('message', 'Social Media Settings Updated Successfully');
        }
    }

    // public function seo_update(Request $request, $id)
    // {
    //     $permission_check = has_permission(41, "edit");
    //     // $permission_check = 1;
    //     if ($permission_check == 0) {
    //         abort(403);
    //     }

    //     $settings = Setting::findOrFail($id);

    //     $settings->meta_title = $request['meta_title'];
    //     $settings->meta_description = $request['meta_description'];
    //     $settings->meta_keywords = $request['meta_keywords'];

    //     if ($settings->save()) {
    //         return redirect()->route('admin.seo_settings')->with('message', 'SEO Settings Updated Successfully');
    //     } else {
    //         return redirect()->route('admin.seo_settings')->with('message', 'SEO Settings Updated Successfully');
    //     }
    // }

    // public function suggestProfiles(Request $request)
    // {
    //     $query = $request->input('query');

    //     // $suggestions = AppUser::where(function ($q) use ($query) {
    //     //     $q->where('first_name', 'LIKE', "%{$query}%")
    //     //         ->orWhere('last_name', 'LIKE', "%{$query}%");
    //     // })
    //     //     ->select('id', DB::raw("CONCAT(first_name, ' ', last_name) AS full_name"))
    //     //     ->get();
    //     $suggestions = AppUser::where('company_name', 'LIKE', "%{$query}%")
    //         ->select('id', 'company_name as full_name')
    //         ->get();

    //     return response()->json($suggestions);
    // }
}
