<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AppUser;
use App\Models\Subscription;

class AdminDashboardController extends Controller
{
    /**
     * Display the Admin Dashboard.
     */
    public function index()
    {
        $totalActiveUsers = AppUser::where('is_active', true)->count();
        $totalSubscribedUsers = Subscription::distinct('user_id')->count('user_id');
        return view('admin.dashboard', compact('totalActiveUsers','totalSubscribedUsers'));
    }
}
