<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AppSetting;
use DataTables;
use Carbon\Carbon;

class AdminAppSettingController extends Controller
{

    public function index()
    {
        // $permission_check = has_permission(39, "list");
        // // $permission_check = 1;
        // if ($permission_check == 0) {
        //     abort(403);
        // }
        // $edit_permission = has_permission(32, "edit");
        $edit_permission = 1;

        $setting = (new AppSetting)->orderBy('id', 'desc')->get();
        return view('admin.app_setting.index', compact('setting', 'edit_permission'));
    }

    public function edit($id)
    {
        // $permission_check = has_permission(39, "edit");
        // // $permission_check = 1;
        // if ($permission_check == 0) {
        //     abort(403);
        // }
        $settings = (new AppSetting)->getDataById($id);
        return view('admin.app_setting.edit', compact('settings'));
    }

    public function update(Request $request, $id)
    {
        //return $request;
        $data = $this->validate($request, [
            'android_latest_version_no' => 'required',
            'android_latest_version_note' => 'required',
            'android_download_link' => 'required',
            'android_force_update_required' => 'required',
            'ios_latest_version_no' => 'required',
            'ios_latest_version_note' => 'required',
            'ios_app_download_link' => 'required',
            'ios_force_update_required' => 'required'
        ]);

        $update = (new AppSetting)->updateData($data, $id);
        return redirect()->route('admin.app_setting.index')->with('message', 'App Settings Update');
    }

}
