<?php

use App\Models\AppUserDevice;
use App\Models\Notification;
use App\Models\SentPushNotification;
use Google\Auth\Credentials\ServiceAccountCredentials;
use Illuminate\Support\Facades\Storage;
use Aws\S3\S3Client;
use Carbon\Carbon;
use Illuminate\Auth\Events\Logout;
use App\Models\AppUser;


if (!function_exists('chapterTypeOptions')) {
    function chapterTypeOptions(): array
    {
        return [
            'note' => 'Notes',
            'reasoning_question' => 'Reasoning Questions',
            'clinical_scenario' => 'Clinical Scenario Questions',
            'mcq' => 'MCQS',
            //'neet_pg_mcq' => 'NEET PG MCQS',
            //'past_paper' => 'Past Paper',
        ];
    }
}


if (!function_exists('getChapterTypeLabel')) {
    function getChapterTypeLabel(string $type): string
    {
        $types = [
            'note' => 'Notes',
            'reasoning_question' => 'Reasoning Questions',
            'clinical_scenario' => 'Clinical Scenario Questions',
            'mcq' => 'MCQS',
            //'neet_pg_mcq' => 'NEET PG MCQS',
            //'past_paper' => 'Past Paper',
        ];

        return $types[$type] ?? ucfirst(str_replace('_', ' ', $type));
    }
}


if (!function_exists('notification')) {
    function notification($user_id, $course_id): Notification
    {
        return Notification::create([
            'user_id'   => $user_id,
            'course_id' => $course_id,
            'title'     => 'Introduce a new chapter in',
            'message'   => 'Introduce a new chapter in',
        ]);
    }
}

function has_permission($menu_id, $permission_type)
{
    return true;
    // $admin_id = Auth::user()->id;
    // $role_id = App\Models\User::where('id', $admin_id)->value('role_id');
    // if ($role_id == 1 || $role_id == 2 || $role_id == 3) {
    //     return true;
    // } else {
    //     if ($permission_type == "list") {
    //         $check_permission = App\Models\AccessRight::where('admin_id', $admin_id)->where('menu_id', $menu_id)->where('list_permissions', 1)->first();
    //         if ($check_permission != '') {
    //             return true;
    //         } else {
    //             return false;
    //         }
    //     } else if ($permission_type == "add") {
    //         $check_permission = App\Models\AccessRight::where('admin_id', $admin_id)->where('menu_id', $menu_id)->where('add_permissions', 1)->first();
    //         if ($check_permission != '') {
    //             return true;
    //         } else {
    //             return false;
    //         }
    //     } else if ($permission_type == "edit") {
    //         $check_permission = App\Models\AccessRight::where('admin_id', $admin_id)->where('menu_id', $menu_id)->where('edit_permissions', 1)->first();
    //         if ($check_permission != '') {
    //             return true;
    //         } else {
    //             return false;
    //         }
    //     } else if ($permission_type == "delete") {
    //         $check_permission = App\Models\AccessRight::where('admin_id', $admin_id)->where('menu_id', $menu_id)->where('delete_permissions', 1)->first();
    //         if ($check_permission != '') {
    //             return true;
    //         } else {
    //             return false;
    //         }
    //     }
    // }
}
// {
//     $content = array(
//         "en" => $message
//     );

//     $headings = array(
//         "en" => $title
//     );

//     $fields = array(
//         'app_id' => env('ONE_SIGNAL_APP_ID'),
//         'headings' => $headings,
//         'android_channel_id' => '3a414518-4c08-44a2-a7b6-44b81c167857',
//         'include_player_ids' => $player_ids,
//         // Array Format
//         'data' => $data,
//         // Array Format
//         'contents' => $content
//     );

//     $fields = json_encode($fields);
//     //    print("\nJSON sent:\n");
// //    print($fields);

//     $ch = curl_init();
//     curl_setopt($ch, CURLOPT_URL, "https://onesignal.com/api/v1/notifications");
//     curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json; charset=utf-8'));
//     curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
//     curl_setopt($ch, CURLOPT_HEADER, FALSE);
//     curl_setopt($ch, CURLOPT_POST, TRUE);
//     curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
//     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

//     $response = curl_exec($ch);
//     //    echo "<pre>";
// //    print_r($response);
// //    exit;
//     curl_close($ch);
//     $store_notification = new \App\SentPushNotification();
//     $store_notification->title = $title;
//     $store_notification->description = $message;
//     $store_notification->created_at = Carbon\Carbon::now();
//     $store_notification->updated_at = Carbon\Carbon::now();
//     $store_notification->push_notification_response_for_android = $response;
//     $store_notification->save();
//     return $response;
// }
// {
//     if ($image != '') {
//         $notification_image = URL::to('/') . "/public/uploads/" . $image;
//     } else {
//         $notification_image = '';
//     }

//     if ($channel_id == 'towney_buzzer_channel') {
//         $sound = 'warning'; // for buzzer sound
//     } else {
//         $sound = 'default'; // for normal notification sound
//     }
//     //API URL of FCM
//     $url = 'https://fcm.googleapis.com/fcm/send';

//     /* api_key available in:
//     Firebase Console -> Project Settings -> CLOUD MESSAGING -> Server key */
//     $api_key = 'AAAA36_cljQ:APA91bF4dDfY_Tu_jud4DTp_LGRiQVpSoJoH4vCHOAJ147IHH-qAfsK8dOgADSXjoj75l4pHbTFXEAnP1-bZOM4pBYM2YDASONi4ituHEKDIuG5lD-LoHl-tgIH44zIkWVGYZSS-zkWe';
//     //    $icon = public_path()."/uploads/logo.png";
//     $notification_data = [
//         "registration_ids" => $reg_ids,
//         "notification" => [
//             "title" => $title,
//             "body" => $message,
//             "icon" => "notification_icon",
//             "sound" => $sound,
//             "image" => $notification_image,
//             "android_channel_id" => $channel_id,
//         ],
//         "data" => $data1,
//     ];

//     $encodedData = json_encode($notification_data);

//     //header includes Content type and api key
//     $headers = array(
//         'Content-Type:application/json',
//         'Authorization:key=' . $api_key
//     );

//     $ch = curl_init();

//     curl_setopt($ch, CURLOPT_URL, $url);
//     curl_setopt($ch, CURLOPT_POST, true);
//     curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
//     curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
//     // Disabling SSL Certificate support temporarly
//     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//     curl_setopt($ch, CURLOPT_POSTFIELDS, $encodedData);
//     // Execute post
//     $result = curl_exec($ch);
//     //   echo "<pre>";print_r($result);exit;
//     if ($result === FALSE) {
//         die('Curl failed: ' . curl_error($ch));
//     }
//     // Close connection
//     curl_close($ch);

//     $store_notification = new \App\SentPushNotification();
//     $store_notification->title = $title;
//     $store_notification->image = $image;
//     $store_notification->description = $message;
//     $store_notification->created_at = Carbon\Carbon::now();
//     $store_notification->updated_at = Carbon\Carbon::now();
//     $store_notification->push_notification_response_for_android = $result;
//     $store_notification->save();

//     return $result;
// }

function send_fcm_push_notification($title, $message, $data1, $reg_ids, $channel_id, $image, $silent = false)
{
    $serviceAccountPath = base_path('config/service-account.json');

    if (!file_exists($serviceAccountPath)) {
        throw new Exception("Service account file not found at $serviceAccountPath");
    }

    $scopes = ['https://www.googleapis.com/auth/firebase.messaging'];

    $credentials = new ServiceAccountCredentials($scopes, $serviceAccountPath);
    $token = $credentials->fetchAuthToken()['access_token'];

    if ($image != '') {
        $notification_image = getPresignedUrl($image);
    } else {
        $notification_image = '';
    }

    $sound = 'default';
    if (!$silent) {
        $data1 = [
            'type' => 'notification'
        ];
    } else {
        $data1 = [
            'type' => 'logout'
        ];
    }
    $url = 'https://fcm.googleapis.com/v1/projects/bic-project-f1624/messages:send';
    foreach ($reg_ids as $reg_id) {
        $notification_data = [
            "message" => [
                "token" => $reg_id,
                "notification" => [
                    "title" => $title,
                    "body" => $message,
                    "image" => $notification_image, // Optional image for the notification
                ],
                "android" => [
                    "notification" => [
                        "sound" => $sound, // Sound to play on Android
                        "channel_id" => $channel_id, // Android notification channel
                    ],
                ],
                "apns" => [
                    "payload" => [
                        "aps" => [
                            "alert" => [
                                "title" => $title,
                                "body" => $message,
                            ],
                            "sound" => $sound, // Sound to play on iOS
                            // "badge" => $badge, // Optional: set the app badge number
                            "mutable-content" => 1, // Optional: if you want to modify the notification content on iOS (e.g., display an image)
                        ],
                    ],
                    "fcm_options" => [
                        "image" => $notification_image, // Optional: image for iOS notification
                    ],
                ],
                "data" => $data1, // Custom data for both iOS and Android
            ],
        ];

        $encodedData = json_encode($notification_data);

        $headers = [
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $token,
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: Bearer ' . $token,
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $encodedData);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Check if the device token is invalid (uninstalled app)
        $responseData = json_decode($response, true);
        // info('Push notification response: ' . json_encode($responseData));
        if (isset($responseData['error']) && ($responseData['error']['details'][0]['errorCode'] === 'UNREGISTERED' || $responseData['error']['status'] === 'INVALID_ARGUMENT' || $responseData['error'] === "NotRegistered" || $responseData['error'] === "InvalidRegistration")) {
            $device = AppUserDevice::where('push_notification_key', $reg_id)->first();
            // info('Device token is invalid: ' . json_encode($device));
            // Check if the user exists
            $app_user = AppUser::find($device->app_user_id);
            event(new Logout('app_user', $app_user, $device->access_token, false));
            $device->delete();
        }
        if ($silent == false) {
            $store_notification = new SentPushNotification();
            $store_notification->title = $title;
            $store_notification->image = $image;
            $store_notification->description = $message;
            $store_notification->created_at = Carbon::now();
            $store_notification->updated_at = Carbon::now();
            $store_notification->push_notification_response_for_android = $response ?? null;
            $store_notification->save();
        }
    }

    return 'success';
}

function createNotification($from_table_primary_id, $comment, $title, $from_table_name, $to_table_primary_key, $to_table_name)
{
    $notification = new Notification();
    $notification->from_table_primary_id = $from_table_primary_id;
    $notification->comment = $comment;
    $notification->title = $title;
    $notification->from_table_name = $from_table_name;
    $notification->to_table_primary_key = $to_table_primary_key;
    $notification->to_table_name = $to_table_name;
    $notification->save();

    return 'success';
}

// function uploads3Image($file, $directory = 'images/products')
// {
//     $filename = md5(rand(1000000, 99999999999) . time()) . '.' . $file->getClientOriginalExtension();
//     $path = $file->storeAs($directory, $filename, 's3');
//     $url = Storage::disk('s3')->url($path);
//     return $url;
// }

function uploadImage($file, $directory = 'uploads')
{
    if (!$file) {
        return null;
    }

    // Generate a unique filename
    $filename = uniqid() . '_' . time() . '.' . $file->getClientOriginalExtension();

    // Check environment
    if (env('APP_ENV') === 'production' || env('APP_ENV') === 'live') {
        // Upload to S3
        $path = $file->storeAs($directory, $filename, 's3');
        $url = Storage::disk('s3')->url($path);
        return $url;
    } else {
        // Upload locally
        $file->move(public_path($directory), $filename);
        return $filename; // Return only the filename
    }
}

// function getPresignedUrl($path, $expiration = '+60 minutes')
// {
//     $s3Client = new S3Client([
//         'version' => 'latest',
//         'region' => env('AWS_DEFAULT_REGION'),
//         'credentials' => [
//             'key' => env('AWS_ACCESS_KEY_ID'),
//             'secret' => env('AWS_SECRET_ACCESS_KEY'),
//         ],
//     ]);

//     $bucket = env('AWS_BUCKET');

//     $cmd = $s3Client->getCommand('GetObject', [
//         'Bucket' => $bucket,
//         'Key' => $path
//     ]);

//     $request = $s3Client->createPresignedRequest($cmd, $expiration);

//     return (string) $request->getUri();
// }

/**
 * Generates a file URL or presigned URL based on the environment.
 *
 * @param string $filename The filename to retrieve
 * @param string $directory The directory where the file is stored (default: 'uploads')
 * @param string $expiration Expiration time for the presigned URL (default: '+60 minutes')
 * @return string|null The file URL (local) or presigned URL (S3)
 */
function getPresignedUrl($filename, $directory = 'uploads', $expiration = '+60 minutes')
{
    if (!$filename) {
        return null;
    }

    // Check the environment
    if (env('APP_ENV') === 'production' || env('APP_ENV') === 'live') {
        // S3 Environment: Generate a presigned URL
        $s3Client = new Aws\S3\S3Client([
            'version' => 'latest',
            'region' => env('AWS_DEFAULT_REGION'),
            'credentials' => [
                'key' => env('AWS_ACCESS_KEY_ID'),
                'secret' => env('AWS_SECRET_ACCESS_KEY'),
            ],
        ]);

        $bucket = env('AWS_BUCKET');
        $path = $directory . '/' . $filename;

        // Generate the command to get the file
        $cmd = $s3Client->getCommand('GetObject', [
            'Bucket' => $bucket,
            'Key' => $path,
        ]);

        // Create a presigned request with expiration
        $request = $s3Client->createPresignedRequest($cmd, $expiration);

        return (string) $request->getUri(); // Return presigned URL
    } else {
        // Local Environment: Return the local file URL
        $filePath = public_path($directory . '/' . $filename);

        // Check if the file exists
        if (file_exists($filePath)) {
            return asset($directory . '/' . $filename);
        }

        return ''; // File not found
    }
}

// function deleteS3Image($url)
// {
//     // Extract the path from the full URL
//     $path = parse_url($url, PHP_URL_PATH);
//     // Remove the leading slash from the path
//     $path = ltrim($path, '/');
//     Storage::disk('s3')->delete($path);
// }

function deleteImage($filename, $directory = 'uploads')
{
    if (!$filename) {
        return false;
    }

    if (env('APP_ENV') === 'production' || env('APP_ENV') === 'live') {
        // Construct the S3 path and delete
        $path = $directory . '/' . $filename;
        return Storage::disk('s3')->delete($path);
    } else {
        // Delete locally
        $filePath = public_path($directory . '/' . $filename);
        if (file_exists($filePath)) {
            return unlink($filePath);
        }
    }
    return false;
}

// function decryptData($encryptedData)
// {
//     // Fetch pre-shared encryption key and IV from the config (stored in .env)
//     $encryptionKey = config('app.custom_encryption_key'); // Base64 encoded key
//     $encryptionIV = config('app.custom_encryption_iv');   // Base64 encoded IV
//     // Base64 decode the key and IV
//     $decodedKey = base64_decode($encryptionKey);
//     $decodedIV = base64_decode($encryptionIV);

//     // Decrypt the data using AES-256-CBC
//     $decryptedData = openssl_decrypt(
//         $encryptedData,   // Base64-decoded encrypted data
//         'AES-256-CBC',                   // Encryption method
//         $decodedKey,                     // Decoded 32-byte encryption key
//         0,                                // Options (0 for default)
//         $decodedIV                        // Decoded 16-byte IV
//     );

//     return $decryptedData; // Return decrypted plain text
// }

// function encryptData($data)
// {
//     // Fetch pre-shared encryption key and IV from the config (stored in .env)
//     $encryptionKey = config('app.custom_encryption_key'); // Base64 encoded key
//     $encryptionIV = config('app.custom_encryption_iv');   // Base64 encoded IV

//     $cipher = 'AES-256-CBC';

//     // Encrypt the data
//     $encryptedData = openssl_encrypt(
//         $data,
//         $cipher,
//         base64_decode($encryptionKey),
//         0,
//         base64_decode($encryptionIV)
//     );

//     return $encryptedData;
// }

// function getPhoneLengths()
// {
//     return [
//         '1' => 10,        // USA, Canada
//         '7' => 10,        // Russia
//         '20' => 10,       // Egypt
//         '27' => 9,        // South Africa
//         '30' => 10,       // Greece
//         '31' => 9,        // Netherlands
//         '32' => 9,        // Belgium
//         '33' => 9,        // France
//         '34' => 9,        // Spain
//         '36' => 9,        // Hungary
//         '39' => 10,       // Italy
//         '40' => 10,       // Romania
//         '41' => 9,        // Switzerland
//         '43' => 10,       // Austria
//         '44' => 10,       // United Kingdom
//         '45' => 8,        // Denmark
//         '46' => 9,        // Sweden
//         '47' => 8,        // Norway
//         '48' => 9,        // Poland
//         '49' => 11,       // Germany
//         '51' => 9,        // Peru
//         '52' => 10,       // Mexico
//         '53' => 8,        // Cuba
//         '54' => 10,       // Argentina
//         '55' => 11,       // Brazil
//         '56' => 9,        // Chile
//         '57' => 10,       // Colombia
//         '58' => 10,       // Venezuela
//         '60' => 9,        // Malaysia
//         '61' => 9,        // Australia
//         '62' => 11,       // Indonesia
//         '63' => 10,       // Philippines
//         '64' => 9,        // New Zealand
//         '65' => 8,        // Singapore
//         '66' => 9,        // Thailand
//         '81' => 10,       // Japan
//         '82' => 10,       // South Korea
//         '84' => 9,        // Vietnam
//         '86' => 11,       // China
//         '90' => 10,       // Turkey
//         '91' => 10,       // India
//         '92' => 10,       // Pakistan
//         '93' => 9,        // Afghanistan
//         '94' => 9,        // Sri Lanka
//         '95' => 9,        // Myanmar
//         '98' => 10,       // Iran
//         '211' => 9,       // South Sudan
//         '212' => 9,       // Morocco
//         '213' => 9,       // Algeria
//         '216' => 8,       // Tunisia
//         '218' => 9,       // Libya
//         '220' => 8,       // Gambia
//         '221' => 9,       // Senegal
//         '222' => 9,       // Mauritania
//         '223' => 8,       // Mali
//         '224' => 9,       // Guinea
//         '225' => 8,       // Côte d'Ivoire
//         '226' => 8,       // Burkina Faso
//         '227' => 8,       // Niger
//         '228' => 8,       // Togo
//         '229' => 8,       // Benin
//         '230' => 8,       // Mauritius
//         '231' => 8,       // Liberia
//         '232' => 8,       // Sierra Leone
//         '233' => 9,       // Ghana
//         '234' => 10,      // Nigeria
//         '235' => 8,       // Chad
//         '236' => 8,       // Central African Republic
//         '237' => 9,       // Cameroon
//         '238' => 7,       // Cape Verde
//         '239' => 7,       // São Tomé and Príncipe
//         '240' => 9,       // Equatorial Guinea
//         '241' => 9,       // Gabon
//         '242' => 9,       // Republic of the Congo
//         '243' => 9,       // DR Congo
//         '244' => 9,       // Angola
//         '245' => 7,       // Guinea-Bissau
//         '246' => 8,       // British Indian Ocean Territory
//         '247' => 8,       // Ascension Island
//         '248' => 7,       // Seychelles
//         '249' => 9,       // Sudan
//         '250' => 9,       // Rwanda
//         '251' => 9,       // Ethiopia
//         '252' => 8,       // Somalia
//         '253' => 8,       // Djibouti
//         '254' => 9,       // Kenya
//         '255' => 9,       // Tanzania
//         '256' => 9,       // Uganda
//         '257' => 8,       // Burundi
//         '258' => 9,       // Mozambique
//         '260' => 9,       // Zambia
//         '261' => 9,       // Madagascar
//         '262' => 9,       // Réunion and Mayotte
//         '263' => 9,       // Zimbabwe
//         '264' => 9,       // Namibia
//         '265' => 9,       // Malawi
//         '266' => 8,       // Lesotho
//         '267' => 8,       // Botswana
//         '268' => 8,       // Eswatini (Swaziland)
//         '269' => 7,       // Comoros
//         '290' => 8,       // Saint Helena
//         '291' => 7,       // Eritrea
//         '297' => 7,       // Aruba
//         '298' => 6,       // Faroe Islands
//         '299' => 6,       // Greenland
//         '358' => 6,       // Åland Islands
//         '355' => 8,       // Albania
//         '1684' => 7,     // American Samoa
//         '376' => 6,       // Andorra
//         '670' => 8,       // East Timor
//         '672' => 6,       // Australian External Territories
//         '673' => 7,       // Brunei
//         '674' => 7,       // Nauru
//         '675' => 8,       // Papua New Guinea
//         '676' => 7,       // Tonga
//         '677' => 7,       // Solomon Islands
//         '678' => 7,       // Vanuatu
//         '679' => 7,       // Fiji
//         '680' => 7,       // Palau
//         '681' => 6,       // Wallis and Futuna
//         '682' => 5,       // Cook Islands
//         '683' => 4,       // Niue
//         '685' => 7,       // Samoa
//         '686' => 8,       // Kiribati
//         '687' => 6,       // New Caledonia
//         '688' => 5,       // Tuvalu
//         '689' => 6,       // French Polynesia
//         '690' => 4,       // Tokelau
//         '691' => 7,       // Micronesia
//         '692' => 7,       // Marshall Islands
//         '850' => 10,      // North Korea
//         '852' => 8,       // Hong Kong
//         '853' => 8,       // Macau
//         '855' => 9,       // Cambodia
//         '856' => 9,       // Laos
//         '880' => 10,      // Bangladesh
//         '886' => 9,       // Taiwan
//         '960' => 7,       // Maldives
//         '961' => 8,       // Lebanon
//         '962' => 9,       // Jordan
//         '963' => 9,       // Syria
//         '964' => 10,      // Iraq
//         '965' => 8,       // Kuwait
//         '966' => 9,       // Saudi Arabia
//         '967' => 9,       // Yemen
//         '968' => 8,       // Oman
//         '971' => 9,       // United Arab Emirates
//         '972' => 9,       // Israel
//         '973' => 8,       // Bahrain
//         '974' => 8,       // Qatar
//         '975' => 8,       // Bhutan
//         '976' => 8,       // Mongolia
//         '977' => 10,      // Nepal
//         '992' => 9,       // Tajikistan
//         '993' => 8,       // Turkmenistan
//         '994' => 9,       // Azerbaijan
//         '995' => 9,       // Georgia
//         '996' => 9,       // Kyrgyzstan
//         '998' => 9,       // Uzbekistan
//     ];
// }

// function getPhonePrefixes()
// {
//     return [
//         '1' => ['2', '3', '4', '5', '6', '7', '8', '9'], // USA, Canada
//         '7' => ['9'], // Russia
//         '20' => ['1'], // Egypt
//         '27' => ['6', '7', '8'], // South Africa
//         '30' => ['6', '7'], // Greece
//         '31' => ['6'], // Netherlands
//         '32' => ['4'], // Belgium
//         '33' => ['6', '7'], // France
//         '34' => ['6', '7'], // Spain
//         '36' => ['3', '7'], // Hungary
//         '39' => ['3'], // Italy
//         '40' => ['7'], // Romania
//         '41' => ['7'], // Switzerland
//         '43' => ['6'], // Austria
//         '44' => ['7'], // United Kingdom
//         '45' => ['2', '4'], // Denmark
//         '46' => ['7'], // Sweden
//         '47' => ['4', '9'], // Norway
//         '48' => ['5', '6', '7'], // Poland
//         '49' => ['1', '5', '6', '7'], // Germany
//         '51' => ['9'], // Peru
//         '52' => ['1', '2', '3', '4', '5', '6', '7', '8'], // Mexico
//         '53' => ['5'], // Cuba
//         '54' => ['1', '2', '3', '4', '5', '6', '7', '8'], // Argentina
//         '55' => ['6', '7', '8', '9'], // Brazil
//         '56' => ['9'], // Chile
//         '57' => ['3'], // Colombia
//         '58' => ['4'], // Venezuela
//         '60' => ['1'], // Malaysia
//         '61' => ['4'], // Australia
//         '62' => ['8'], // Indonesia
//         '63' => ['9'], // Philippines
//         '64' => ['2', '3', '7', '8'], // New Zealand
//         '65' => ['8', '9'], // Singapore
//         '66' => ['6', '8', '9'], // Thailand
//         '81' => ['7', '8', '9'], // Japan
//         '82' => ['1'], // South Korea
//         '84' => ['3', '7', '8', '9'], // Vietnam
//         '86' => ['1'], // China
//         '90' => ['5'], // Turkey
//         '91' => ['6', '7', '8', '9'], // India
//         '92' => ['3'], // Pakistan
//         '93' => ['7'], // Afghanistan
//         '94' => ['7'], // Sri Lanka
//         '95' => ['9'], // Myanmar
//         '98' => ['9'], // Iran
//         '211' => ['9'], // South Sudan
//         '212' => ['6'], // Morocco
//         '213' => ['5', '6', '7'], // Algeria
//         '216' => ['2', '9'], // Tunisia
//         '218' => ['9'], // Libya
//         '220' => ['3'], // Gambia
//         '221' => ['7'], // Senegal
//         '222' => ['2'], // Mauritania
//         '223' => ['6'], // Mali
//         '224' => ['6'], // Guinea
//         '225' => ['0', '4', '5', '6', '7'], // Côte d'Ivoire
//         '226' => ['6'], // Burkina Faso
//         '227' => ['9'], // Niger
//         '228' => ['9'], // Togo
//         '229' => ['9'], // Benin
//         '230' => ['5'], // Mauritius
//         '231' => ['8'], // Liberia
//         '232' => ['7'], // Sierra Leone
//         '233' => ['2', '5'], // Ghana
//         '234' => ['7', '8', '9'], // Nigeria
//         '235' => ['6'], // Chad
//         '236' => ['7'], // Central African Republic
//         '237' => ['6'], // Cameroon
//         '238' => ['9'], // Cape Verde
//         '239' => ['9'], // São Tomé and Príncipe
//         '240' => ['2'], // Equatorial Guinea
//         '241' => ['7'], // Gabon
//         '242' => ['9'], // Republic of the Congo
//         '243' => ['8', '9'], // DR Congo
//         '244' => ['9'], // Angola
//         '245' => ['5'], // Guinea-Bissau
//         '246' => ['3'], // British Indian Ocean Territory
//         '247' => ['6'], // Ascension Island
//         '248' => ['9'], // Seychelles
//         '249' => ['9'], // Sudan
//         '250' => ['7'], // Rwanda
//         '251' => ['9'], // Ethiopia
//         '252' => ['6'], // Somalia
//         '253' => ['7'], // Djibouti
//         '254' => ['7'], // Kenya
//         '255' => ['6', '7'], // Tanzania
//         '256' => ['7'], // Uganda
//         '257' => ['7'], // Burundi
//         '258' => ['8'], // Mozambique
//         '260' => ['9'], // Zambia
//         '261' => ['3'], // Madagascar
//         '262' => ['6'], // Réunion and Mayotte
//         '263' => ['7'], // Zimbabwe
//         '264' => ['8'], // Namibia
//         '265' => ['7'], // Malawi
//         '266' => ['5'], // Lesotho
//         '267' => ['7'], // Botswana
//         '268' => ['7'], // Eswatini
//         '269' => ['7'], // Comoros
//         '290' => ['2'], // Saint Helena
//         '291' => ['7'], // Eritrea
//         '297' => ['5'], // Aruba
//         '298' => ['2'], // Faroe Islands
//         '299' => ['5'], // Greenland
//         '358' => ['4'], // Finland
//         '355' => ['6'], // Albania
//         '376' => ['3'], // Andorra
//         '672' => ['5'], // Australian External Territories
//         '852' => ['9'], // Hong Kong
//         '853' => ['6'], // Macau
//         '880' => ['1'], // Bangladesh
//         '886' => ['9'], // Taiwan
//     ];
// }


// if (!function_exists('generateSprintJwtToken')) {
//     /**
//      * Generate a JWT token for Sprint Verify
//      *
//      * @param array $payload
//      * @return string
//      */
//     function generateSprintJwtToken(array $payload): string
//     {
//         $header = [
//             'typ' => 'JWT',
//             'alg' => 'HS256',
//         ];

//         $secret = env('SPRINT_VERIFY_JWT_SECRET'); // Use Sprint Verify's JWT secret

//         $headerEncoded = base64_encode(json_encode($header));
//         $payloadEncoded = base64_encode(json_encode($payload));

//         $signature = hash_hmac('sha256', "$headerEncoded.$payloadEncoded", $secret, true);
//         $signatureEncoded = base64_encode($signature);

//         return "$headerEncoded.$payloadEncoded.$signatureEncoded";
//     }
// }

// if (!function_exists('gstVerify')) {
//     /**
//      * Verify GST using SprintVerify API
//      *
//      * @param string $refId
//      * @param string $idNumber
//      * @param bool $filingStatus
//      * @return array
//      */
//     function gstVerify($refId, $idNumber, $filingStatus)
//     {
//         // Prepare JWT payload
//         $timestamp = now()->timestamp;
//         $jwtPayload = [
//             'timestamp' => $timestamp,
//             'partnerId' => env('PARTNER_ID'),
//             'reqid' => $refId, // Reference ID
//         ];

//         // Generate the JWT token using the helper function
//         $token = generateSprintJwtToken($jwtPayload);

//         try {
//             // Make the API request to SprintVerify's GST verification endpoint
//             $response = Http::withHeaders([
//                 'Content-Type' => 'application/json',
//                 'Token' => $token,
//                 'accept' => 'application/json',
//                 'authorisedkey' => env('SPRINT_VERIFY_AUTHORISED_KEY'),
//             ])->post(env('SPRINT_VERIFY_BASE_URL') . '/gst_verify', [
//                         'refid' => $refId,
//                         'id_number' => $idNumber,
//                         'filing_status' => $filingStatus, // Include filing status (true or false)
//                     ]);

//             // Return the response as an array
//             return $response->json();
//         } catch (\Exception $e) {
//             // Handle errors and return the exception message
//             return [
//                 'error' => true,
//                 'message' => $e->getMessage(),
//             ];
//         }
//     }
// }

// function formatWhatsAppTimestamp($timestamp)
// {
//     $date = Carbon::parse($timestamp);
//     $now = Carbon::now();

//     if ($date->isToday()) {
//         return $date->format('h:i A'); // Example: 02:30 PM
//     } elseif ($date->isYesterday()) {
//         return 'Yesterday';
//     } elseif ($date->diffInDays($now) < 7) {
//         return $date->format('l'); // Example: Tuesday, Wednesday, etc.
//     } else {
//         return $date->format('d/m/Y'); // Example: 05/02/2024
//     }
// }


/**
 * Convert @mentions in caption to @username%id format
 */
// function formatMentions($caption)
// {
//     preg_match_all('/@([\w]+)/', $caption, $matches);

//     if (!empty($matches[1])) {
//         foreach ($matches[1] as $username) {
//             info('username: ' . $username);
//             $usernameMd = str_replace('_', '-', $username);
//             info('Modified Username ' . $usernameMd);
//             $user = AppUser::where('username', encryptData($usernameMd))->first();
//             if ($user) {
//                 $caption = str_replace("@{$username}", "@{$username}%{$user->id}", $caption);
//             }
//         }
//     }

//     return $caption;
// }

// function formatNumber($num)
// {
//     if ($num >= 10000000) {
//         return round($num / 10000000, 1) . 'C'; // Crores (Indian numbering)
//     } elseif ($num >= 100000) {
//         return round($num / 100000, 1) . 'L'; // Lakhs (Indian numbering)
//     } elseif ($num >= 1000) {
//         return round($num / 1000, 1) . 'K'; // Thousands
//     }
//     return (string) $num; // Return as is if less than 1000
// }

// function formatBytes($bytes, $precision = 2)
// {
//     $units = ['B', 'KB', 'MB', 'GB', 'TB'];

//     $bytes = max($bytes, 0);
//     $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
//     $pow = min($pow, count($units) - 1);

//     $bytes /= pow(1024, $pow);

//     return round($bytes, $precision) . ' ' . $units[$pow];
// }
