<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Subscription;

class ExpireSubscriptions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:expire-subscriptions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Expire subscriptions whose end_date has passed';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info("Expired subscriptions CronJob Working");
        $count = Subscription::where('status', 'active')
            ->whereDate('end_date', '<', now())
            ->update(['status' => 'expired']);

        $this->info("Expired {$count} subscriptions.");
    }
}
